/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.table;

import filenet.vw.api.VWParticipant;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkParticipantHistory;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class VWStepNParticipantRenderer
extends DefaultListCellRenderer {
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        component.applyComponentOrientation(compOrientation);
        ((JLabel)component).setText("");
        ((JLabel)component).setIcon(null);
        if (value != null) {
            if (value instanceof String) {
                ((JLabel)component).setText(VWStepNParticipantRenderer.toString(value));
                ((JLabel)component).setIcon(null);
            }
            if (value instanceof VWParticipant) {
                ((JLabel)component).setText(VWStepNParticipantRenderer.toString(value));
                ((JLabel)component).setIcon(null);
            } else if (value instanceof VWTrkParticipant) {
                VWTrkParticipant participant = (VWTrkParticipant)value;
                ((JLabel)component).setText(VWStepNParticipantRenderer.toString(participant));
                int status = participant.getStatus();
                ((JLabel)component).setIcon(VWImageLoader.createStatusIcon(status));
            } else if (value instanceof VWTrkStep) {
                VWTrkStep step = (VWTrkStep)value;
                ((JLabel)component).setText(VWStepNParticipantRenderer.toString(step));
                ImageIcon icon = step.getStatusIcon();
                ((JLabel)component).setIcon(icon);
            } else if (value instanceof VWTrkStepOccurrence) {
                VWTrkStepOccurrence occurrence = (VWTrkStepOccurrence)value;
                VWTrkStep step = occurrence.getStep();
                int occurrenceIndex = occurrence.getOccurrenceIndex() + 1;
                String text = VWStepNParticipantRenderer.toString(step) + " [" + occurrenceIndex + "]";
                ((JLabel)component).setText(text);
                ImageIcon icon = occurrence.getStatusIcon();
                ((JLabel)component).setIcon(icon);
            }
        }
        return component;
    }

    public static String toString(VWTrkParticipant trkParticipant) {
        VWParticipantItem trkItem = new VWParticipantItem(trkParticipant.getParticipant());
        String name = trkItem.getDisplayName();
        String queueName = null;
        VWTrkParticipantHistory participantHistory = trkParticipant.getParticipantHistory();
        if (trkItem == null || trkItem.getShortName() == null) {
            queueName = trkParticipant.getQueueName();
        }
        VWParticipant user = null;
        if (trkParticipant.isActive()) {
            user = trkParticipant.getLockedUser();
        } else if (participantHistory != null) {
            user = participantHistory.getUser();
        }
        if (user != null && user.getParticipantName() != null) {
            VWParticipantItem userItem = new VWParticipantItem(user);
            if (name != null) {
                if (userItem.getShortName() != null && userItem.getShortName().length() > 0 && VWStringUtils.compare(trkItem.getShortName(), userItem.getShortName()) != 0) {
                    name = name + "(" + userItem.getDisplayName() + ")";
                }
            } else {
                name = queueName != null ? "[" + queueName + "]" + " " + userItem.getDisplayName() : "";
            }
        } else if (name == null) {
            name = queueName == null ? VWResource.s_noneParticipant : "[" + queueName + "]";
        }
        return name;
    }

    public static String toString(VWTrkStep step) {
        String name = step.getStepName();
        if (name == null) {
            return VWResource.s_none;
        }
        return name;
    }

    public static String toString(VWParticipant participant) {
        VWParticipantItem vwParticipantItem = new VWParticipantItem(participant);
        return VWStepNParticipantRenderer.toString(vwParticipantItem.getDisplayName());
    }

    public static String toString(Object value) {
        if (value instanceof String) {
            int seperatorIndex;
            String str = (String)value;
            if (str.charAt(0) == '\"') {
                str = str.substring(1, str.length() - 1);
            }
            if ((seperatorIndex = str.indexOf(":")) != -1) {
                str = str.substring(0, seperatorIndex);
            }
            return str;
        }
        if (value instanceof VWTrkParticipant) {
            return VWStepNParticipantRenderer.toString((VWTrkParticipant)value);
        }
        if (value instanceof VWTrkStep) {
            return VWStepNParticipantRenderer.toString((VWTrkStep)value);
        }
        if (value instanceof VWParticipant) {
            return VWStepNParticipantRenderer.toString((VWParticipant)value);
        }
        return "";
    }
}

